' PicBasic Pro program to display result of 
' 10-bit A/D conversion on LCD
'
' Connect analog input to channel-0 (RA0)

' Define LCD registers and bits
DEFINE	LCD_DREG	PORTD
DEFINE	LCD_DBIT	4
DEFINE	LCD_RSREG	PORTC
DEFINE	LCD_RSBIT	0
DEFINE	LCD_EREG	PORTA
DEFINE	LCD_EBIT	4
DEFINE  OSC  10
adval	VAR	WORD		' Create adval to store result


	TRISA = %11111111  	' Set PORTA to all input
	ADCON1 = %10000010 	' Set PORTA analog and RIGHT justify result
	ADCON0 = %11000001	' Configure and turn on A/D Module
	Pause 800       	' Wait .5 second


loop:	ADCON0.2 = 1		' Start Conversion

notdone: Pause 5
	IF ADCON0.2 = 1 Then notdone	' Wait for low on bit-2 of ADCON0, conversion finished

	adval.highbyte = ADRESH	' Move HIGH byte of result to adval
	adval.lowbyte = ADRESL	' Move LOW byte of result to adval

	LCDOut $fe, 1		' Clear screen
	LCDOut "Value: ", DEC adval	' Display the decimal value  

	Pause 500		' Wait .1 second

	GoTo loop		' Do it forever
	End

